#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'

require_relative '../..//module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../..//pages/landing'
require_relative '../../pages/login'
require_relative '../../pages/eula'
require_relative '../../pages/roa'
require_relative '../../common/common'
require_relative '../../pages/user_menu'
require_relative '../../pages/launchpad'
require_relative '../../helper/modal'
require_relative '../../module/database/MySqlUtility'

describe '[Story# VAR-1749: Landing - Not enrolled ]
          [Story# VAR-2271: Landing Page - Not Enrolled]
          [Story# VAR-4079: Update app version on footer and about page]
          [Story# VAR-11889: Automate Version Number Update 4.4.0]'  do
  include DriverUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @roa = Roa.new(@driver)
    @common = Common.new(@driver)
    @user_menu = UserMenuOption.new(@driver)
    @launchpad = Launchpad.new(@driver)
    @modal = Modal.new(@driver)
  end

  after(:all) do
    @driver.close
  end

  context '[AC#VAR-1805|TC#VAR-1910 - Landing Page - Not Enrolled in VHA ]
           [AC#VAR-2345,2763|TC#VAR-2769 - Updated Landing Page - Not Enrolled in VHA]
           [AC#VAR-4148|TC#VAR-4149 - Update app version]
           [AC#VAR-5151|TC#VAR-5152: Validate Automate Version Number Update]' do

    xit "Login" do
      @common.loginEndsOnHome(VarVeteran01)
      @landing.footerUserInfo_element.when_present(TIME_OUT_LIMIT)
      @landing.modalTitle_element.when_present(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.modalTitle == "Veterans Health Administration Enrollment"}
    end

    xit "Landing page" do
      @landing.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@landing.modalTitle).to eq('Veterans Health Administration Enrollment')
      expect(@landing.contentLine1).to eq('Currently we cannot find a record of your enrollment in the Veterans Health Administration.')
      expect(@landing.contentLine2).to eq('To use this app, you need:')
      expect(@landing.contentLine3).to eq('To be actively enrolled in VA Healthcare')
      expect(@landing.contentLine4).to eq('To have been seen for medical care at a VA Medical Center (VAMC) or Community Based Clinic (CBOC)')
      expect(@landing.contentLine5).to eq('Additionally, for some types of care, your selected facility may have additional rules for using this app to book an appointment.')
      expect(@landing.contentLine6).to eq('If you have not enrolled, want to learn more, or would like to begin the enrollment process go to the Apply for VA Health Benefits webpage.')
      expect(@landing.contentLine7).to eq('If you are enrolled please contact 1-877-222-VETS Monday through Friday between 8 a.m. and 8 p.m. ET and a representative will provide assistance. You may also contact your local VA health care facility.')
      expect(@landing.contentLine8).to eq('To find a facility near you, visit the VA Facility Locator.')


      expect(@landing.appVersion).to eq("VA Appointments - v4.10.0")
      expect(@landing.footerUserInfo).to eq("Logged in as veteran01, zztest")
    end

    # Verify the Modal displayed when VA Enrollment Link is clicked
    #Click the VA Enrollment Link
    xit "Landing page" do
      @landing.modalTitle_element.when_present(TIME_OUT_LIMIT)
      @landing.va_enrollment_link_element.when_present(TIME_OUT_LIMIT)
      @landing.va_enrollment_link
      @modal.modalDialog_element.when_present(TIME_OUT_LIMIT)

      #Click Return in the modal to make sure the modal closes and the VHA Enrollment landing paeg is displayed
      @landing.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@landing.modalTitle).to eq('Veterans Health Administration Enrollment')
      expect(@modal.content_element.text).to eq("You are about to leave the VA Appointments app. Select CONTINUE to proceed to the link information selected, or select RETURN to return to the VA Appointments app.")
      expect(@modal.buttons_elements[1].text).to eq("Return")
      @modal.buttons_elements[1].click
      #focus
#      expect( @landing.va_enrollment_link_element).to eq(@landing.element_with_focus)

      #Validate that clicking Continue on the modal takes user to the VHA enrollment page
      @landing.va_enrollment_link
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq('Confirmation')
      expect(@modal.buttons_elements[0].text).to eq("Continue")
      @modal.buttons_elements[0].click

      #VHA Enrollment Site is displayed
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("https://www.DOMAIN.EX/HEALTHBENEFITS/apply/index.asp")
      switchWindowToWindowHandleFirst
      @landing.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@landing.modalTitle).to eq('Veterans Health Administration Enrollment')

      #Validate the Facility Locator link
      @landing.va_facility_locator_link
      @modal.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@modal.modalTitle).to eq('Confirmation')
      expect(@modal.buttons_elements[0].text).to eq("Continue")
      @modal.buttons_elements[0].click

      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("https://www.DOMAIN.EX/directory/guide/division.asp?dnum=1")
      switchWindowToWindowHandleFirst
      @landing.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@landing.modalTitle).to eq('Veterans Health Administration Enrollment')

    end

    xit "Defect#VAR-3017: Patient without dfn is able to login to VAR app " do
      #zztest.patient14 has no dfn and a single icn
      @common.logoutAndLogbackWithADifferentUser(VarPatient14)

      @landing.footerUserInfo_element.when_present(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.footerUserInfo == "Logged in as patient14, zztest"}
      #expect(@landing.footerUserInfo).to eq("Logged in as patient14, zztest")

      @landing.modalTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@landing.modalTitle).to eq('Veterans Health Administration Enrollment')
      expect(@landing.contentLine1).to eq('Currently we cannot find a record of your enrollment in the Veterans Health Administration.')
      expect(@landing.contentLine2).to eq('To use this app, you need:')
      expect(@landing.contentLine3).to eq('To be actively enrolled in VA Healthcare')
      expect(@landing.contentLine4).to eq('To have been seen for medical care at a VA Medical Center (VAMC) or Community Based Clinic (CBOC)')
      expect(@landing.contentLine5).to eq('Additionally, for some types of care, your selected facility may have additional rules for using this app to book an appointment.')
      expect(@landing.contentLine6).to eq('If you have not enrolled, want to learn more, or would like to begin the enrollment process go to the Apply for VA Health Benefits webpage.')
      expect(@landing.contentLine7).to eq('If you are enrolled please contact 1-877-222-VETS Monday through Friday between 8 a.m. and 8 p.m. ET and a representative will provide assistance. You may also contact your local VA health care facility.')
      expect(@landing.contentLine8).to eq('To find a facility near you, visit the VA Facility Locator.')

    end
  end
end






TT